package com.ejie.ab04b.service.nora;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.nora.CalleDao;
import com.ejie.ab04b.model.nora.Calle;

/**
 * CalleServiceImpl.
 * 
 * @author GFI
 */
@Service(value = "calleService")
public class CalleServiceImpl implements CalleService {

	@Autowired()
	private CalleDao calleDao;

	/**
	 * Finds a single row in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  Calle
	 *
	 * @param calle the calle
	 * @return the calle
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public Calle find(Calle calle) {
		return (Calle) this.calleDao.find(calle);
	}

	/**
	 * Finds a List of rows in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  List
	 *
	 * @param calle the calle
	 * @return the list
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public List<Calle> findAll(Calle calle) {
		return (List<Calle>) this.calleDao.findAll(calle);
	}

	/**
	 * Finds a List of rows in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  startsWith
	 *            Boolean
	 *  List
	 *
	 * @param calle the calle
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public List<Calle> findAllLike(Calle calle, Boolean startsWith) {
		return (List<Calle>) this.calleDao.findAllLike(calle, startsWith);
	}

	/**
	 * Counts rows in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  Long
	 *
	 * @param calle the calle
	 * @return the long
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public Long findAllCount(Calle calle) {
		return this.calleDao.findAllCount(calle);
	}

	/**
	 * Counts rows in the Calle table.
	 * 
	 *  calle
	 *            Calle
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param calle the calle
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public Long findAllLikeCount(Calle calle, Boolean startsWith) {
		return this.calleDao.findAllCount(calle);
	}
}